<?php
/**
 * Plugin Name: KMD Reels Pro
 * Plugin URI: https://fofoofodata.com
 * Description: Strict Reels for WordPress posts — TikTok-style player on single posts, 9:16 desktop with blur, mobile full-screen, pro SVG controls, glowing progress, category scroll, VAST ads, and video SEO.
 * Version: 1.2.0
 * Author: KMD
 * Author URI: https://fofoofodata.com
 * License: GPLv2 or later
 * Text Domain: kmd-reels-pro
 */
if ( ! defined( 'ABSPATH' ) ) exit;

define( 'KMD_REELS_PRO_VERSION', '1.2.0' );
define( 'KMD_REELS_PRO_DIR', plugin_dir_path( __FILE__ ) );
define( 'KMD_REELS_PRO_URL', plugin_dir_url( __FILE__ ) );

require_once KMD_REELS_PRO_DIR . 'includes/class-kmd-reels-admin.php';
require_once KMD_REELS_PRO_DIR . 'includes/class-kmd-reels-frontend.php';
require_once KMD_REELS_PRO_DIR . 'includes/class-kmd-reels-seo.php';

register_activation_hook(__FILE__, function(){
  if ( ! get_option('kmd_reels_settings') ) {
    update_option('kmd_reels_settings', KMD_Reels_Admin::defaults());
  }
});
