<?php
if ( ! defined( 'ABSPATH' ) ) exit;
class KMD_Reels_SEO {
  public static function init(){
    add_action('wp_head', [__CLASS__, 'video_schema'], 5);
    add_filter('wp_resource_hints', [__CLASS__, 'resource_hints'], 10, 2);
  }
  public static function settings(){ return class_exists('KMD_Reels_Admin') ? KMD_Reels_Admin::get() : []; }
  public static function extract_video($content){
    if(preg_match('/<video[^>]*src=["\']([^"\']+)/i',$content,$m)) return esc_url_raw($m[1]);
    if(preg_match('/<source[^>]*src=["\']([^"\']+)/i',$content,$m)) return esc_url_raw($m[1]);
    if(preg_match('/<iframe[^>]*src=["\']([^"\']+)/i',$content,$m)) return esc_url_raw($m[1]);
    return '';
  }
  public static function video_schema(){
    if(!is_singular('post')) return;
    global $post; $s = self::settings();
    $video = self::extract_video($post->post_content);
    $thumb = get_the_post_thumbnail_url($post->ID,'full');
    if(!$video) return;
    $json = [
      "@context"=>"https://schema.org",
      "@type"=>"VideoObject",
      "name"=> get_the_title($post),
      "description"=> wp_strip_all_tags(get_the_excerpt($post)),
      "thumbnailUrl"=> $thumb ? [$thumb] : [],
      "uploadDate"=> get_the_date('c', $post),
      "contentUrl"=> $video,
      "publisher"=>["@type"=>"Organization","name"=>get_bloginfo('name')],
    ];
    if(!empty($s['seo_regions_allowed'])) $json["regionsAllowed"] = $s['seo_regions_allowed'];
    if(!empty($s['seo_content_location'])) $json["contentLocation"] = $s['seo_content_location'];
    echo '<script type="application/ld+json">'.wp_json_encode($json).'</script>';
    if($thumb){ echo '<meta property="og:image" content="'.esc_url($thumb).'">'; }
    echo '<meta property="og:type" content="video.other">';
    echo '<meta name="twitter:card" content="player">';
  }
  public static function resource_hints($urls, $relation_type){
    if('preconnect' !== $relation_type || !is_singular('post')) return $urls;
    global $post; $src = self::extract_video($post->post_content);
    if($src){
      $parts = wp_parse_url($src);
      if(!empty($parts['scheme']) && !empty($parts['host'])){
        $host = $parts['scheme'].'://'.$parts['host'];
        $urls[] = $host;
      }
    }
    return $urls;
  }
}
KMD_Reels_SEO::init();
