<?php
if ( ! defined( 'ABSPATH' ) ) exit;
class KMD_Reels_Frontend {
  public static function init(){
    add_action('wp_enqueue_scripts',[__CLASS__,'assets']);
    add_filter('the_content',[__CLASS__,'render_single_as_reel'], 9999);
  }
  public static function settings(){ return class_exists('KMD_Reels_Admin') ? KMD_Reels_Admin::get() : []; }
  public static function assets(){
    if(is_singular('post')){
      wp_enqueue_style('kmd-reels', KMD_REELS_PRO_URL.'public/css/kmd-reels.css', [], KMD_REELS_PRO_VERSION);
      wp_enqueue_script('kmd-reels', KMD_REELS_PRO_URL.'public/js/kmd-reels.js', ['jquery'], KMD_REELS_PRO_VERSION, true);
      $s = self::settings();
      wp_localize_script('kmd-reels','KMD_REELS_DATA',[
        'settings'=>$s,
        'referrer'=> isset($_SERVER['HTTP_REFERER']) ? esc_url_raw($_SERVER['HTTP_REFERER']) : home_url('/'),
        'siteurl'=> home_url('/'),
        'is_mobile'=> wp_is_mobile(),
      ]);
    }
  }
  private static function first_media_from_content($content){
    if(preg_match('/<source[^>]*src=["\']([^"\']+)/i', $content, $m)) return esc_url_raw($m[1]);
    if(preg_match('/<video[^>]*src=["\']([^"\']+)/i', $content, $m)) return esc_url_raw($m[1]);
    if(preg_match('/<iframe[^>]*src=["\']([^"\']+)/i', $content, $m)) return esc_url_raw($m[1]);
    return '';
  }
  private static function build_reels_markup($context_post_id){
    $s = self::settings();
    $args = ['post_type'=>'post','posts_per_page'=>-1,'ignore_sticky_posts'=>true,'orderby'=>'date','order'=>'DESC'];
    $cats = wp_get_post_categories($context_post_id, ['fields'=>'ids']);
    if($cats){ $args['category__in'] = $cats; }
    $q = new WP_Query($args);
    if(!$q->have_posts()) return '<p class="kmd-reels-empty">No posts found.</p>';
    ob_start(); ?>
    <div class="kmd-reels-root" data-accent="<?php echo esc_attr($s['accent_color']);?>" data-blur="<?php echo esc_attr($s['blur_enabled']);?>">
      <div class="kmd-reels-overlay"></div>
      <div class="kmd-reels-dim"></div>

      <button class="kmd-close kmd-pos-<?php echo esc_attr($s['close_position']);?>" aria-label="Close">
        <svg class="kmd-icon" viewBox="0 0 24 24">
          <circle cx="12" cy="12" r="11" fill="none" stroke="#fff" stroke-width="2"/>
          <line x1="8" y1="8" x2="16" y2="16" stroke="#fff" stroke-width="2"/>
          <line x1="16" y1="8" x2="8" y2="16" stroke="#fff" stroke-width="2"/>
        </svg>
      </button>

      <div class="kmd-reels-stack">
        <?php $i=0; $active=0; while($q->have_posts()): $q->the_post();
          $poster = get_the_post_thumbnail_url(get_the_ID(),'full');
          $meta = get_post_meta(get_the_ID(),'kmd_video_url', true);
          $vid = $meta ?: self::first_media_from_content(get_post_field('post_content', get_the_ID()));
          if(get_the_ID()==$context_post_id) $active=$i; ?>
          <section class="kmd-reel" data-bg="<?php echo esc_url($poster);?>" data-postid="<?php the_ID();?>">
            <div class="kmd-frame" style="--kmd-progress:0%;border-radius:<?php echo intval($s['frame_radius']);?>px;">
              <?php if($vid): ?>
              <video class="kmd-video" playsinline webkit-playsinline preload="metadata" <?php echo $s['autoplay_sound']? '' : 'muted'; ?> poster="<?php echo esc_url($poster);?>">
                <source src="<?php echo esc_url($vid);?>">
              </video>
              <?php endif; ?>

              <?php if(!empty($s['center_play'])): ?>
              <button class="kmd-center-play" aria-label="Play/Pause" hidden>
                <svg class="kmd-icon" viewBox="0 0 24 24"><polygon points="8,5 19,12 8,19"/></svg>
              </button>
              <?php endif; ?>

              <div class="kmd-controls">
                <?php if(!empty($s['controls_mute'])): ?>
                <button class="kmd-btn kmd-mute" aria-label="Mute">
                  <svg class="kmd-icon" viewBox="0 0 24 24"><polygon points="3,10 7,10 12,6 12,18 7,14 3,14"/><path d="M14 9a4 4 0 0 1 0 6"/></svg>
                  <span class="kmd-label">Mute</span>
                </button>
                <?php endif; ?>
                <?php if(!empty($s['controls_share'])): ?>
                <button class="kmd-btn kmd-share" aria-label="Share">
                  <svg class="kmd-icon" viewBox="0 0 24 24"><circle cx="18" cy="5" r="3"/><circle cx="6" cy="12" r="3"/><circle cx="18" cy="19" r="3"/><line x1="8.7" y1="13.5" x2="15.3" y2="17.5"/><line x1="15.3" y1="6.5" x2="8.7" y2="10.5"/></svg>
                  <span class="kmd-label">Share</span>
                </button>
                <?php endif; ?>
                <?php if(!empty($s['controls_download'])): ?>
                <a class="kmd-btn kmd-download" download href="<?php echo esc_url($vid);?>" aria-label="Download">
                  <svg class="kmd-icon" viewBox="0 0 24 24"><path d="M12 3v12"/><polyline points="7,12 12,17 17,12"/><rect x="4" y="19" width="16" height="2"/></svg>
                  <span class="kmd-label">Download</span>
                </a>
                <?php endif; ?>
              </div>

              <div class="kmd-progress"><span></span></div>

              <div class="kmd-watermark">
                <?php if(!empty($s['watermark_image'])): ?>
                  <img src="<?php echo esc_url($s['watermark_image']);?>" alt="wm"/>
                <?php else: ?>
                  <span><?php echo esc_html($s['watermark_text']);?></span>
                <?php endif; ?>
              </div>

              <div class="kmd-ad-badge" hidden><?php echo esc_html($s['ad_label']);?></div>
              <button class="kmd-ad-skip" hidden>Skip</button>
            </div>
          </section>
        <?php $i++; endwhile; wp_reset_postdata(); ?>
      </div>

      <div class="kmd-nav kmd-desktop-only">
        <button class="kmd-nav-up" aria-label="Previous"><svg class="kmd-icon" viewBox="0 0 24 24"><polyline points="6,15 12,9 18,15"/></svg></button>
        <button class="kmd-nav-down" aria-label="Next"><svg class="kmd-icon" viewBox="0 0 24 24"><polyline points="6,9 12,15 18,9"/></svg></button>
      </div>

      <script>window.KMD_REEL_ACTIVE_INDEX = <?php echo intval($active);?>;</script>
    </div>
    <?php
    return ob_get_clean();
  }
  public static function render_single_as_reel($content){
    if(!is_singular('post')) return $content;
    return self::build_reels_markup(get_the_ID());
  }
}
KMD_Reels_Frontend::init();
