<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class KMD_Reels_Admin {
  public static function init(){
    add_action('admin_menu', [__CLASS__, 'menu']);
    add_action('admin_init', [__CLASS__, 'register']);
  }
  public static function defaults(){
    return [
      'accent_color'   => '#ff7a00',
      'autoplay_sound' => 1,
      'blur_enabled'   => 1,
      'frame_radius'   => 25,
      'watermark_text' => get_bloginfo('name'),
      'watermark_image'=> '',
      'controls_mute'  => 1,
      'controls_share' => 1,
      'controls_download' => 1,
      'center_play'    => 1,
      'close_position' => 'top-left',
      // Monetization
      'vast_enabled'   => 0,
      'vast_tag_url'   => '',
      'ad_skip_seconds'=> 5,
      'ad_frequency'   => 3,
      'ad_label'       => 'Ad',
      'ad_fallback_url'=> '',
      // SEO
      'seo_regions_allowed' => '',
      'seo_content_location'=> '',
    ];
  }
  public static function get(){ return wp_parse_args( get_option('kmd_reels_settings', []), self::defaults() ); }
  public static function menu(){
    add_menu_page(__('KMD Reels Pro','kmd-reels-pro'), __('KMD Reels Pro','kmd-reels-pro'), 'manage_options', 'kmd-reels-pro', [__CLASS__,'page'], 'dashicons-format-video', 59);
  }
  public static function register(){
    register_setting('kmd_reels_group', 'kmd_reels_settings', ['type'=>'array','sanitize_callback'=>[__CLASS__,'sanitize']]);
  }
  public static function sanitize($in){
    $d = self::defaults(); $o = wp_parse_args($in, $d);
    $o['accent_color'] = sanitize_hex_color($o['accent_color']);
    $o['autoplay_sound'] = !empty($o['autoplay_sound']) ? 1 : 0;
    $o['blur_enabled'] = !empty($o['blur_enabled']) ? 1 : 0;
    $o['frame_radius'] = intval($o['frame_radius']);
    $o['watermark_text'] = sanitize_text_field($o['watermark_text']);
    $o['watermark_image'] = esc_url_raw($o['watermark_image']);
    foreach(['controls_mute','controls_share','controls_download','center_play'] as $k){ $o[$k] = !empty($o[$k]) ? 1 : 0; }
    $o['close_position'] = in_array($o['close_position'],['top-left','top-right']) ? $o['close_position'] : 'top-left';
    $o['vast_enabled'] = !empty($o['vast_enabled']) ? 1 : 0;
    $o['vast_tag_url'] = esc_url_raw($o['vast_tag_url']);
    $o['ad_skip_seconds'] = max(0, intval($o['ad_skip_seconds']));
    $o['ad_frequency'] = max(1, intval($o['ad_frequency']));
    $o['ad_label'] = sanitize_text_field($o['ad_label']);
    $o['ad_fallback_url'] = esc_url_raw($o['ad_fallback_url']);
    $o['seo_regions_allowed'] = sanitize_text_field($o['seo_regions_allowed']);
    $o['seo_content_location'] = sanitize_text_field($o['seo_content_location']);
    return $o;
  }
  public static function page(){ $s = self::get(); ?>
    <div class="wrap">
      <h1>KMD Reels Pro – Settings</h1>
      <h2 class="nav-tab-wrapper">
        <a href="#tab-display" class="nav-tab nav-tab-active">Display</a>
        <a href="#tab-monetization" class="nav-tab">Monetization</a>
        <a href="#tab-seo" class="nav-tab">Video SEO</a>
      </h2>
      <form method="post" action="options.php">
        <?php settings_fields('kmd_reels_group'); ?>
        <div id="tab-display" class="kmd-tab" style="display:block;">
          <table class="form-table">
            <tr><th>Accent / Glow Color</th><td><input type="text" name="kmd_reels_settings[accent_color]" value="<?php echo esc_attr($s['accent_color']);?>" class="regular-text" placeholder="#ff7a00"></td></tr>
            <tr><th>Autoplay with Sound</th><td><label><input type="checkbox" name="kmd_reels_settings[autoplay_sound]" value="1" <?php checked($s['autoplay_sound'],1);?>> Enable</label></td></tr>
            <tr><th>Blurred Background (Desktop)</th><td><label><input type="checkbox" name="kmd_reels_settings[blur_enabled]" value="1" <?php checked($s['blur_enabled'],1);?>> Enable</label></td></tr>
            <tr><th>Frame Radius</th><td><input type="number" name="kmd_reels_settings[frame_radius]" min="0" max="40" value="<?php echo esc_attr($s['frame_radius']);?>"> px</td></tr>
            <tr><th>Close Button</th><td><select name="kmd_reels_settings[close_position]">
              <option value="top-left" <?php selected($s['close_position'],'top-left');?>>Top Left</option>
              <option value="top-right" <?php selected($s['close_position'],'top-right');?>>Top Right</option></select></td></tr>
            <tr><th>Controls Visible</th><td>
              <label><input type="checkbox" name="kmd_reels_settings[controls_mute]" value="1" <?php checked($s['controls_mute'],1);?>> Mute</label>&nbsp;&nbsp;
              <label><input type="checkbox" name="kmd_reels_settings[controls_share]" value="1" <?php checked($s['controls_share'],1);?>> Share</label>&nbsp;&nbsp;
              <label><input type="checkbox" name="kmd_reels_settings[controls_download]" value="1" <?php checked($s['controls_download'],1);?>> Download</label>
            </td></tr>
            <tr><th>Center Play/Pause</th><td><label><input type="checkbox" name="kmd_reels_settings[center_play]" value="1" <?php checked($s['center_play'],1);?>> Show while paused</label></td></tr>
          </table>
        </div>
        <div id="tab-monetization" class="kmd-tab" style="display:none;">
          <table class="form-table">
            <tr><th>Enable VAST Ads</th><td><label><input type="checkbox" name="kmd_reels_settings[vast_enabled]" value="1" <?php checked($s['vast_enabled'],1);?>> Enable</label></td></tr>
            <tr><th>VAST Tag URL</th><td><input type="text" name="kmd_reels_settings[vast_tag_url]" value="<?php echo esc_attr($s['vast_tag_url']);?>" class="regular-text" placeholder="https://...vast.xml"></td></tr>
            <tr><th>Ad Skip (seconds)</th><td><input type="number" name="kmd_reels_settings[ad_skip_seconds]" min="0" max="30" value="<?php echo esc_attr($s['ad_skip_seconds']);?>"></td></tr>
            <tr><th>Ad Frequency</th><td><input type="number" name="kmd_reels_settings[ad_frequency]" min="1" max="10" value="<?php echo esc_attr($s['ad_frequency']);?>"> <span class="description">Show an ad every X reels.</span></td></tr>
            <tr><th>Ad Label</th><td><input type="text" name="kmd_reels_settings[ad_label]" value="<?php echo esc_attr($s['ad_label']);?>" class="regular-text"></td></tr>
            <tr><th>Fallback Ad Video</th><td><input type="text" id="kmd_ad_fb" name="kmd_reels_settings[ad_fallback_url]" value="<?php echo esc_attr($s['ad_fallback_url']);?>" class="regular-text"> <button type="button" class="button kmd-upload" data-target="kmd_ad_fb">Upload/Select</button></td></tr>
          </table>
        </div>
        <div id="tab-seo" class="kmd-tab" style="display:none;">
          <table class="form-table">
            <tr><th>Regions Allowed (ISO codes, comma)</th><td><input type="text" name="kmd_reels_settings[seo_regions_allowed]" value="<?php echo esc_attr($s['seo_regions_allowed']);?>" class="regular-text" placeholder="US,GB,CA"></td></tr>
            <tr><th>Content Location</th><td><input type="text" name="kmd_reels_settings[seo_content_location]" value="<?php echo esc_attr($s['seo_content_location']);?>" class="regular-text" placeholder="Accra, Ghana"></td></tr>
          </table>
        </div>
        <?php submit_button(); ?>
      </form>
    </div>
    <script>
    jQuery(function($){
      // Tabs
      $('.nav-tab').on('click', function(e){
        e.preventDefault(); $('.nav-tab').removeClass('nav-tab-active'); $(this).addClass('nav-tab-active');
        $('.kmd-tab').hide(); $($(this).attr('href')).show();
      });
      // Media uploader
      function openFrame(target){
        var frame = wp.media({ title: 'Select Media', multiple:false });
        frame.on('select', function(){
          var a = frame.state().get('selection').first().toJSON();
          jQuery('#'+target).val(a.url);
        });
        frame.open();
      }
      jQuery('.kmd-upload').on('click', function(e){ e.preventDefault(); openFrame(jQuery(this).data('target')); });
    });
    </script>
    <?php
  }
}
KMD_Reels_Admin::init();
